#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int MAXN = 500005;

int N;
vector<int> graph[MAXN];
vector<int> hasPlatform(MAXN, 0);
vector<int> changeRoom(MAXN, 0);
vector<int> minJumps(MAXN, -1);

void dfs(int node, int prevJump, int prevPlatform) {
    int currJumps = prevJump + 1;

    if (hasPlatform[node] == 1) {
        currJumps = 1;
        prevPlatform = node;
    }

    if (changeRoom[node] != 0) {
        if (prevPlatform == 0 || changeRoom[node] != prevPlatform) {
            currJumps = 1;
        }
    }

    minJumps[node] = currJumps;

    for (int nextNode : graph[node]) {
        if (minJumps[nextNode] == -1) {
            dfs(nextNode, currJumps, prevPlatform);
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    cin >> N;

    for (int i = 0; i < N - 1; i++) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    for (int i = 1; i <= N; i++) {
        cin >> hasPlatform[i];
    }

    for (int i = 1; i <= N; i++) {
        cin >> changeRoom[i];
    }

    dfs(1, 0, 0);

    for (int i = 1; i <= N; i++) {
        cout << minJumps[i] << " ";
    }

    return 0;
}